#ifndef LLF_PKI_PRIV_KEY_DB_DEF_H
#define LLF_PKI_PRIV_KEY_DB_DEF_H

/*
 * This file is #included in the middle of the struct declaration for CRYSRSAPrivKey_t
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_RSA_Types.h file !!!!
 *  2) only the CRYS_RSA_Types.h file should include this file. 
 */


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 09:23:41 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version LLF_RSA_priv_key_db_def.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

   
   union
   { 
     struct
     { 
       /* the Hn value - used to optimized the exponent - calculated by the 
          CRYS_RSA_Build_PubKey function */
       DxUint32_t HnSizeInBits;
       DxUint32_t Hn[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
       
     }NonCrt;
     
     struct
     {
       /* the Hp value - used to optimized the exponent - calculated by the 
          CRYS_RSA_Build_PubKey function */
       DxUint32_t HpSizeInBits;
       DxUint32_t Hp[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
 
       /* the Hq value - used to optimized the exponent - calculated by the 
          CRYS_RSA_Build_PubKey function */
       DxUint32_t HqSizeInBits;
       DxUint32_t Hq[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS];
 
     }Crt;
     
   }LLF;



#endif
